/*******************************************************************************
 * Copyright (C) 2002, 2003
 * ingenieurbuero fuer innovative informationstechnik (iiit)
 * Dipl.-Ing. Joerg Beckmann, Dortmund, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or look at http://www.gnu.org/copleft/lesser.html.
 *
 * version $Id: StringUtilTest.java,v 1.1 2003/03/12 21:09:16 joerg Exp $
 ******************************************************************************/

package de.iiit.util;

import java.security.*;
import junit.framework.*;

/**
 *
 * @author joerg
 */
public class StringUtilTest extends TestCase
{
    /** CVS Version Tag */
    private static final String vcid = "$Id: StringUtilTest.java,v 1.1 2003/03/12 21:09:16 joerg Exp $";
    
    public StringUtilTest(java.lang.String testName)
    {
        super(testName);
    }
    
    public static void main(java.lang.String[] args)
    {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite(StringUtilTest.class);
        
        return suite;
    }
    
    /** Test of removeSpaces method, of class de.iiit.util.StringUtil. */
    public void testRemoveSpaces()
    {
        System.out.println("StringUtilTest.testRemoveSpaces");
        
        String src = "Hello World !";
        String dst = "HelloWorld!";
        
        String result = StringUtil.removeSpaces(src);
        
        Assert.assertEquals(dst, result);
    }
    
//    /** Test of byteArrayToHexString method, of class de.iiit.util.StringUtil. */
//    public void testByteArrayToHexString()
//    {
//        System.out.println("StringUtilTest.testByteArrayToHexString");
//        
//        // Add your test code below by replacing the default call to fail.
//        fail("The test case is empty.");
//    }
    
    /** Test of hexStringToByteArray method, of class de.iiit.util.StringUtil. */
    public void testHexStringToByteArray()
    {
        System.out.println("StringUtilTest.testHexStringToByteArray");
        
        String src1 = "1234567890ABCDEFFEDCBA0987654321";
        String src2 = "1234567890abcdeffedcba0987654321";
        
        byte[] b1 = StringUtil.hexStringToByteArray(src1);
        byte[] b2 = StringUtil.hexStringToByteArray(src2);
        
        long t = System.currentTimeMillis();
        
        for (int i = 0; i < 1000; i++)
        {
            b1 = StringUtil.hexStringToByteArray(src1);
            b2 = StringUtil.hexStringToByteArray(src2);
        }
        
        t = System.currentTimeMillis() - t;
        System.out.println("1000 conversions done within " + t + " ms.");

        Assert.assertEquals("Length of byte arrays", b1.length, b2.length);

        for (int i = 0; i < b1.length; i++)
        {
            Assert.assertEquals("Byte value at position " + i, b1[i], b2[i]);
        }
    }
    
    /** Test of hexStringToByteArray method, of class de.iiit.util.StringUtil. */
    public void testByteArrayToHexString()
    {
        System.out.println("StringUtilTest.testByteArrayToHexString");
        
        String src1 = "1234567890ABCDEFFEDCBA0987654321";
        String src2 = "1234567890abcdeffedcba0987654321";
        
        byte[] b1 = StringUtil.hexStringToByteArray(src1);
        byte[] b2 = StringUtil.hexStringToByteArray(src2);

        String result1 = null;
        String result2 = null;
        
        long t = System.currentTimeMillis();
        
        for (int i = 0; i < 1000; i++)
        {
            result1 = StringUtil.byteArrayToHexString(b1);
            result2 = StringUtil.byteArrayToHexString(b2);
        }
        
        t = System.currentTimeMillis() - t;
        System.out.println("1000 conversions done within " + t + " ms.");

        Assert.assertEquals(src2, result1);
        Assert.assertEquals(src2, result2);        
    }
    
    /** Test of hexStringToByteArray method, of class de.iiit.util.StringUtil. */
    public void testHexStringToByteArrayToHexString()
    {
        System.out.println("StringUtilTest.testHexStringToByteArrayToHexString");
        
        String src1 = "1234567890ABCDEFFEDCBA0987654321";
        String src2 = "1234567890abcdeffedcba0987654321";
        
        String result1 = null;
        String result2 = null;
        
        long t = System.currentTimeMillis();
        
        for (int i = 0; i < 1000; i++)
        {
            byte[] b1 = StringUtil.hexStringToByteArray(src1);
            byte[] b2 = StringUtil.hexStringToByteArray(src2);

            result1 = StringUtil.byteArrayToHexString(b1);
            result2 = StringUtil.byteArrayToHexString(b2);
        }
        
        t = System.currentTimeMillis() - t;
        System.out.println("1000 conversions done within " + t + " ms.");

        Assert.assertEquals(src2, result1);
        Assert.assertEquals(src2, result2);        
    }
    
    /** Test of md5Sum method, of class de.iiit.util.StringUtil. */
    public void testMd5Sum()
    {
        System.out.println("StringUtilTest.testMd5Sum");
        
        String src = "Hello World !";

        try
        {
            long t = System.currentTimeMillis();

            for (int i = 0; i < 1000; i++)
            {
                String result = StringUtil.md5Sum(src);
            }

            t = System.currentTimeMillis() - t;
            System.out.println("1000 calculations done within " + t + " ms.");
        }
        catch (NoSuchAlgorithmException nsae)
        {
            fail("Can't calculate MD5 sums");
        }
    }
    
}

/**
 * $Log: StringUtilTest.java,v $
 * Revision 1.1  2003/03/12 21:09:16  joerg
 * New unit test.
 *
 */
