/*******************************************************************************
 * Copyright (C) 2002, 2003
 * ingenieurbuero fuer innovative informationstechnik (iiit)
 * Dipl.-Ing. Joerg Beckmann, Dortmund, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or look at http://www.gnu.org/copleft/lesser.html.
 *
 * version $Id: GenericTimeoutCacheTest.java,v 1.1 2003/03/12 20:12:38 joerg Exp $
 ******************************************************************************/

package de.iiit.cache;

import java.util.*;
import junit.framework.*;

/** 
 * Implements a test suite for GenericInvalidationCache
 *
 * @version $Revision: 1.1 $ $Date: 2003/03/12 20:12:38 $
 */
public class GenericTimeoutCacheTest extends TestCase
{
    /** CVS Version Tag */
    private static final String vcid = "$Id: GenericTimeoutCacheTest.java,v 1.1 2003/03/12 20:12:38 joerg Exp $";
    
    private static final int TIMEOUT   = 100;
    private static final int SLEEPTIME =  10;
    
    private GenericTimeoutCache cache = null;

    public GenericTimeoutCacheTest(java.lang.String testName)
    {
        super(testName);
    }
    
    public static void main(java.lang.String[] args)
    {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite(GenericInvalidationCacheTest.class);
        
        return suite;
    }
    
    private void setup()
    {
        cache = new GenericTimeoutCache(TIMEOUT, SLEEPTIME);
    }
    
    private void reset()
    {
        cache.clear();
        cache.shutdown();
        cache = null;
    }
    
    private static void sleep(int ms)
    {
        try
        {
            Thread.sleep(ms);
        }
        catch (Exception e)
        {
            // do nothing 
        }
    }
    
    public void testTimeout()
    {
        System.out.println("GenericTimeoutCacheTest.testTimeout");

        setup();
        
        Object obj = new Object();
        String name = "Object";
            
        long t1 = System.currentTimeMillis();
        
        cache.addElement(name, obj);
        
        Object result = null;
        
        try
        {
            result = cache.getElement(name);
        }
        catch (CacheFaultException cfe)
        {
            fail("Cached object not found");
        }
        
        Assert.assertEquals("Element read from cache", obj, result);

        long t2 = System.currentTimeMillis();

        long dt = TIMEOUT - (t2 - t1);
//        System.out.println("Sleeping " + dt + " ms");
        sleep((int) dt);
        
        try
        {
            result = cache.getElement(name);
            fail("Cached object is not deleted");
        }
        catch (CacheFaultException cfe)
        {
            // do nothing
        }
        
        reset();
    }
    
}

/**
 * $Log: GenericTimeoutCacheTest.java,v $
 * Revision 1.1  2003/03/12 20:12:38  joerg
 * New unit test.
 *
 */
