/*******************************************************************************
 * Copyright (C) 2002, 2003
 * ingenieurbuero fuer innovative informationstechnik (iiit)
 * Dipl.-Ing. Joerg Beckmann, Dortmund, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or look at http://www.gnu.org/copleft/lesser.html.
 *
 * version $Id: ConfigReader.java,v 1.12 2003/04/02 15:56:30 joerg Exp $
 ******************************************************************************/

package de.iiit.xmlconfig;

import de.iiit.util.*;

import org.apache.xerces.parsers.*;
import org.apache.log4j.Logger;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import java.io.*;
import java.util.*;

/** Reads a XML configuration file using Apache Xerces as a SAX parser.
 * It extends the Xerces class DefaultHandler with its own implemetation of
 * startElement() and endElement().
 * @see de.iiit.xmlconfig.Configuration
 * @version $Revision: 1.12 $ $Date: 2003/04/02 15:56:30 $
 * @deprecated This class is deprecated. Use {@link Configuration#load(java.lang.String)} instead.
 */
public class ConfigReader extends DefaultHandler
{
    /** CVS Version Tag */
    private static final String vcid = "$Id: ConfigReader.java,v 1.12 2003/04/02 15:56:30 joerg Exp $";
    
    private Configuration rootConfig    = null;
    private Configuration currentConfig = null;

    private Stack configStack = new Stack();
    
    private Logger logger = Logger.getLogger(this.getClass());

    /** Creates a new instance of ConfigReader */
    public ConfigReader()
    {
    }
    
    /** Implementation of the call-back method defined in Xerces' DefaultHandler
     * @param uri The Namespace URI, or the empty string if the element has no Namespace URI or if Namespace processing is not being performed.
     * @param localName The local name (without prefix), or the empty string if Namespace processing is not being performed.
     * @param qName The qualified name (with prefix), or the empty string if qualified names are not available.
     * @param attrs The attributes attached to the element. If there are no attributes, it shall be an empty Attributes object.
     */    
    public void startElement(String uri, String localName, String qName, Attributes attrs) 
    {        
        Configuration c = new Configuration(qName.toLowerCase());
        
        if (rootConfig == null)
        {
            rootConfig = c;
            configStack.push(c);
        }
        else
        {
            currentConfig.addSubConfiguration(c);
            configStack.push(currentConfig);
        }
        
        currentConfig = c;
        
        int iMax = attrs.getLength();
        
        for (int i = 0; i < iMax; i++)
        {
            c.addAttribute(attrs.getQName(i).toLowerCase(), attrs.getValue(i));
        }
    }
    
    /** Implementation of the call-back method defined in Xerces' DefaultHandler
     * @param uri The Namespace URI, or the empty string if the element has no Namespace URI or if Namespace processing is not being performed.
     * @param localName The local name (without prefix), or the empty string if Namespace processing is not being performed.
     * @param qName The qualified XML 1.0 name (with prefix), or the empty string if qualified names are not available.
     */    
    public void endElement(String uri, String localName, String qName ) 
    {
        currentConfig = (Configuration) configStack.pop();
    }

    /** This is the main method of this class. It tries to read the XML file named
     * <I>filename</I> and delivers it as an Object of class <I>Configuration</I>
     * @see de.iiit.xmlconfig.Configuration
     * @return The read configuration or if the file was empty.
     * @param filename The name of the file to read.
     * @throws FileNotFoundException any exception occuring while reading and parsing the file is passed through.
     * @throws IOException any exception occuring while reading and parsing the file is passed through.
     * @throws SAXException any exception occuring while reading and parsing the file is passed through.
     */    
    public Configuration readConfigFile(String filename) 
    throws FileNotFoundException, IOException, SAXException
    {
        boolean logFlag = LogUtil.loggerIsInitialized();

        String msg = "Start reading file <" + filename + ">";
        if (logFlag)
            logger.debug(msg);
        else
            System.out.println(msg);
        
        rootConfig = null;
        currentConfig = null;
        
        SAXParser p = new SAXParser();
        p.setContentHandler(this);
        p.parse(new InputSource(new FileReader(filename)));
        
        msg = "Finished reading file <" + filename + ">.";
        if (logFlag)
            logger.debug(msg);
        else
            System.out.println(msg);

        return rootConfig;
    }
}

/**
 * $Log: ConfigReader.java,v $
 * Revision 1.12  2003/04/02 15:56:30  joerg
 * This class is now deprecated.
 *
 * Revision 1.11  2003/01/01 21:03:49  joerg
 * Copyright-Statement aktualisiert
 *
 * Revision 1.10  2002/12/10 21:53:39  joerg
 * Copyright-Statement korrigiert.
 *
 * Revision 1.9  2002/11/30 14:54:11  joerg
 * Javadoc ergaenzt
 *
 * Revision 1.8  2002/11/23 14:21:52  joerg
 * GPL-Statements eingefuegt
 *
 * Revision 1.7  2002/11/23 13:04:04  joerg
 * JavaDoc verbessert
 *
 * Revision 1.6  2002/11/22 16:34:20  joerg
 * JavaDoc-Kommentare eingefuegt
 *
 * Revision 1.5  2002/11/03 20:37:01  joerg
 * Log4J wird nur dann benutzt, wenn der Logger bereits initialisiert ist.
 * Andernfalls erfolgt die Ausgabe nach System.out.
 *
 * Revision 1.4  2002/11/03 19:39:19  joerg
 * Methode printConfig() von Klasse ConfigReader in Klasse Configuration verschoben
 *
 * Revision 1.3  2002/11/03 15:10:19  joerg
 * Klasse 'ConfigurationElement' umbenannt in 'Configuration'
 *
 * Revision 1.2  2002/11/03 14:44:03  joerg
 * Keys auf UpperCase umgestellt,
 * zusaetzliche Methoden zu Loggen der gelesenen Configuration
 *
 * Revision 1.1  2002/10/31 15:05:16  joerg
 * Erste Version bestehend aus Config-Reader, Logging und Expressions.
 *
 */
