/*******************************************************************************
 * Copyright (C) 2002, 2003
 * ingenieurbuero fuer innovative informationstechnik (iiit)
 * Dipl.-Ing. Joerg Beckmann, Dortmund, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or look at http://www.gnu.org/copleft/lesser.html.
 *
 * version $Id: StringUtil.java,v 1.9 2003/03/12 21:06:38 joerg Exp $
 ******************************************************************************/

package de.iiit.util;

import java.security.*;

/** This class includes utility methods to use with <I>String</I> objects 
 * @version $Revision: 1.9 $ $Date: 2003/03/12 21:06:38 $
 */
public class StringUtil
{
    /** CVS Version Tag */
    private static final String vcid = "$Id: StringUtil.java,v 1.9 2003/03/12 21:06:38 joerg Exp $";
    
    private static final char[] hexadecimal = 
            {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 
             'a', 'b', 'c', 'd', 'e', 'f'};

    private static MessageDigest md5 = null;
             
    /** Creates a new instance of StringUtil */
    private StringUtil()
    {
    }
    
    /** Remove all space characters (' ') from a given <I>String</I>
     * @param s The <I>String</I> object from which all spaces should be removed
     * @return The <I>String</I> without spaces
     */    
    public static final String removeSpaces(String s)
    {
        return s.replaceAll(" ", "");
    }
    
    /** Converts a byte array into a hex string
     * @param b The byte array to convert
     * @return The string
     */    
    public static final String byteArrayToHexString(byte[] b)
    {
        char[] buffer = new char[b.length*2];

        int k = 0;        
        for (int i = 0; i < b.length; i++) 
        {
            int low  = (int)  (b[i] & 0x0f);
            int high = (int) ((b[i] & 0xf0) >> 4);
            buffer[k++] = hexadecimal[high];
            buffer[k++] = hexadecimal[low];
        }

        return new String(buffer);
    }

    /** Converts a hex string into a byte array
     * @param s The String to convert
     * @return a byte array
     */    
    public static final byte[] hexStringToByteArray(String s)
    {
        int l = s.length() / 2;
        byte[] buffer = new byte[l];
        
        int j = 0;
        
        for (int i = 0; i < l; i++)
        {
            int k = j + 2;
            String b = s.substring(j, k);
            buffer[i] = (byte) Integer.parseInt(b, 16);
            j = k;
        }
        
        return buffer;
    }
    
    /** Calculates a MD5-sum.
     * @param source The byte array to use for the calculations
     * @throws NoSuchAlgorithmException if the algorithm is not available in the caller's environment.
     * @return The calculated md5 sum as a hex string.
     */    
    public static String md5Sum(byte[] source) throws NoSuchAlgorithmException
    {
        if (md5 == null)
            md5 = MessageDigest.getInstance("MD5");
        
        byte[] md5Bytes;
        
        synchronized(md5) 
        {
            md5Bytes = md5.digest(source);
        }
        
        return byteArrayToHexString(md5Bytes);
    }
    
    /** Calculates a MD5-sum.
     * @param source The string to use for the calculations
     * @throws NoSuchAlgorithmException if the algorithm is not available in the caller's environment.
     * @return The calculated md5 sum as a hex string.
     */    
    public static String md5Sum(String source) throws NoSuchAlgorithmException
    {
        return md5Sum(source.getBytes());
    }

}

/**
 * $Log: StringUtil.java,v $
 * Revision 1.9  2003/03/12 21:06:38  joerg
 * Minor optimizations
 *
 * Revision 1.8  2003/01/01 21:03:49  joerg
 * Copyright-Statement aktualisiert
 *
 * Revision 1.7  2002/12/10 21:53:39  joerg
 * Copyright-Statement korrigiert.
 *
 * Revision 1.6  2002/12/07 20:31:07  joerg
 * Javadoc weiter vervollstaendigt.
 *
 * Revision 1.5  2002/12/07 20:00:41  joerg
 * Mehrere neue Methoden rund um MD5-Summen
 *
 * Revision 1.4  2002/11/30 14:54:11  joerg
 * Javadoc ergaenzt
 *
 * Revision 1.3  2002/11/23 14:21:52  joerg
 * GPL-Statements eingefuegt
 *
 * Revision 1.2  2002/11/22 16:37:06  joerg
 * JavaDoc-Kommentare eingefuegt
 *
 * Revision 1.1  2002/11/03 21:54:23  joerg
 * Neue Klasse fuer zusaetzliche String-Methoden
 *
 */
