/*******************************************************************************
 * Copyright (C) 2002, 2003
 * ingenieurbuero fuer innovative informationstechnik (iiit)
 * Dipl.-Ing. Joerg Beckmann, Dortmund, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or look at http://www.gnu.org/copleft/lesser.html.
 *
 * version $Id: FileSearch.java,v 1.7 2003/01/01 21:03:49 joerg Exp $
 ******************************************************************************/

package de.iiit.util;

import org.apache.log4j.Logger;

import java.io.*;

/** This class searches for a given file name in a set of directories 
 * @version $Revision: 1.7 $ $Date: 2003/01/01 21:03:49 $
 */
public class FileSearch
{
    /** CVS Version Tag */
    private static final String vcid = "$Id: FileSearch.java,v 1.7 2003/01/01 21:03:49 joerg Exp $";
    
    private static final String[] DEFAULT_PATH = { ".", "etc", "/usr/local/etc", "/etc" };
    
    private static String[] searchPath = DEFAULT_PATH;
    private static String searchPathAsString = null;
    private static Logger logger = Logger.getLogger("FileSearch");
    
    /** Creates a new instance of FileSearch */
    protected FileSearch()
    {
    }

    /** Set the set of directories to search in.
     * @param path An array of directory names.
     */    
    public static void setSearchPath(String[] path)
    {
        searchPath = path;
        searchPathAsString = null;
    }
    
    /** Returns the array of directory names to search in
     * @return The array of directory names to search in
     */    
    public static String[] getSearchPath()
    {
        return searchPath;
    }
    
    /** Returns the current set of directories as a <I>String</I>. The format of the
     * string depends on the operating system.
     * @return The current set of directories as a <I>String</I>
     */    
    public static String getSearchPathAsString()
    {
        if (searchPathAsString == null)
        {
            searchPathAsString = "";
        
            int iMax = searchPath.length;
            for (int i = 0; i < iMax; i++)
            {
                if (i > 0)
                    searchPathAsString += File.pathSeparator;
                    
                searchPathAsString += searchPath[i];
            }
        }
               
        return searchPathAsString;
    }
    
    /** Searches for a given file in a pre-defined set of directories.
     * @param filename The name of the file to search for
     * @return The absolute path of the file of <B>null</B> if the file was not found.
     */    
    public static String search(String filename)
    {
        String result = null;

        String msg = "Searching for <" + filename + "> in <" + getSearchPathAsString() + ">";
        boolean logFlag = LogUtil.loggerIsInitialized();
        
        if (logFlag)
            logger.debug(msg);
        else
            System.out.println(msg);                
            
        int iMax = searchPath.length;
        for (int i = 0; i < iMax && result == null; i++)
        {
            File file = new File(searchPath[i], filename);
            
            if (file.canRead())
            {
                msg = "File <" + filename + "> found in <" + searchPath[i] + ">";

                if (logFlag)
                    logger.debug(msg);
                else
                    System.out.println(msg);                
                
                result = file.getPath();
            }
        }
        
        return result;
    }
}

/**
 * $Log: FileSearch.java,v $
 * Revision 1.7  2003/01/01 21:03:49  joerg
 * Copyright-Statement aktualisiert
 *
 * Revision 1.6  2002/12/10 21:53:39  joerg
 * Copyright-Statement korrigiert.
 *
 * Revision 1.5  2002/11/30 14:54:11  joerg
 * Javadoc ergaenzt
 *
 * Revision 1.4  2002/11/23 14:21:52  joerg
 * GPL-Statements eingefuegt
 *
 * Revision 1.3  2002/11/22 16:37:06  joerg
 * JavaDoc-Kommentare eingefuegt
 *
 * Revision 1.2  2002/11/03 20:36:52  joerg
 * Log4J wird nur dann benutzt, wenn der Logger bereits initialisiert ist.
 * Andernfalls erfolgt die Ausgabe nach System.out.
 *
 * Revision 1.1  2002/10/31 15:05:16  joerg
 * Erste Version bestehend aus Config-Reader, Logging und Expressions.
 *
 */
