/*******************************************************************************
 * Copyright (C) 2002, 2003
 * ingenieurbuero fuer innovative informationstechnik (iiit)
 * Dipl.-Ing. Joerg Beckmann, Dortmund, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or look at http://www.gnu.org/copleft/lesser.html.
 *
 * version $Id: JdbcUtil.java,v 1.7 2003/01/01 21:03:49 joerg Exp $
 ******************************************************************************/

package de.iiit.jdbc;

import de.iiit.xmlconfig.*;

import java.util.*;
import java.sql.*;

import org.apache.log4j.*;

/** Provides utility methods for JDBC 
 * @version $Revision: 1.7 $ $Date: 2003/01/01 21:03:49 $
 */
public class JdbcUtil
{
    /** CVS Version Tag */
    private static final String vcid = "$Id: JdbcUtil.java,v 1.7 2003/01/01 21:03:49 joerg Exp $";
    
    /** the String "ClassName" */    
    public static final String JDBC_DRIVER = "ClassName";

    private static Logger logger = Logger.getLogger("JdbcUtil");

    /** Creates a new instance of JdbcUtil */
    private JdbcUtil()
    {
    }

    /** Register configured JDBC driver classes
     * @param cfgVector a vector of Configuration objects. The name of the attribute searched for is
     * defined in the JDBC_DRIVER.
     * @throws Exception any exception occured inside the method
     */    
    public static void registerJdbcDriver(Vector cfgVector) throws Exception
    {
        String          className = null;
        Configuration   cfg;
        Class           driverClass;
        Driver          driver;
        
        try
        {
            int iMax = cfgVector.size();

            for (int i = 0; i < iMax; i++)
            {
                cfg = (Configuration) cfgVector.get(i);
                className = cfg.getAttribute(JDBC_DRIVER);

                driverClass = Class.forName(className);
                driver = (Driver) driverClass.newInstance();

                DriverManager.registerDriver(driver);
                logger.info("JDBC driver <" + className + "> successful registered");  
            }
        }
        catch (ClassNotFoundException e)
        {
            logger.fatal("Class <" + className + "> not found", e);
            throw e;
        }
        catch (Exception e)
        {
            logger.fatal("Can't register driver of class <" + className + ">");
            throw e;
        }        
    }        

}

/**
 * $Log: JdbcUtil.java,v $
 * Revision 1.7  2003/01/01 21:03:49  joerg
 * Copyright-Statement aktualisiert
 *
 * Revision 1.6  2002/12/10 21:53:39  joerg
 * Copyright-Statement korrigiert.
 *
 * Revision 1.5  2002/11/30 14:54:11  joerg
 * Javadoc ergaenzt
 *
 * Revision 1.4  2002/11/26 14:42:56  joerg
 * Javadoc verbessert, alten Code entfernt
 *
 * Revision 1.3  2002/11/23 14:21:52  joerg
 * GPL-Statements eingefuegt
 *
 * Revision 1.2  2002/11/23 14:16:17  joerg
 * JavaDoc-Kommentare eingefuegt
 *
 * Revision 1.1  2002/11/21 21:48:05  joerg
 * Schale um JDBC mit Connection-Pooling.
 * Nur die benoetigten Klassen und methoden sind realisiert.
 *
 */
