/*******************************************************************************
 * Copyright (C) 2002, 2003
 * ingenieurbuero fuer innovative informationstechnik (iiit)
 * Dipl.-Ing. Joerg Beckmann, Dortmund, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or look at http://www.gnu.org/copleft/lesser.html.
 *
 * version $Id: GenericCache.java,v 1.8 2003/03/12 13:20:09 joerg Exp $
 ******************************************************************************/

package de.iiit.cache;

import java.util.*;

/** 
 * Implements a very generic cache 
 *
 * @version $Revision: 1.8 $ $Date: 2003/03/12 13:20:09 $
 */
public class GenericCache
{
    /** CVS Version Tag */
    private static final String vcid = "$Id: GenericCache.java,v 1.8 2003/03/12 13:20:09 joerg Exp $";
    
    private Hashtable cache = new Hashtable();

    /** Creates a new instance of GenericCache */
    public GenericCache()
    {
    }

    /** Clears the cache */
    protected void clear()
    {
        cache.clear();
    }
    
    /** 
     * Retrieves the number of elements stored in the cache 
     *
     * @return the number of elements
     */
    protected int size()
    {
        return cache.size();
    }
    
    /** 
     * Add a new element to the cache. If an element with the same key already exists
     * it will be replaced.
     *
     * @param key The unique key of the cache entry
     * @param value The value of the cache entry
     */    
    public void addElement(Object key, Object value)
    {
        cache.put(key, value);
    }
    
    /** 
     * Retrieves a cache-entry
     *
     * @param key The unique key of the cache entry to retrieve
     * @throws CacheFaultException if there is no entry with the given key
     * @return The cache entry with the given key
     */    
    public Object getElement(Object key) throws CacheFaultException
    {
        Object value = null;
        
        value = cache.get(key);
        
        if (value == null)
            throw new CacheFaultException();
        
        return value;
    }
    
    /** 
     * Get all defined keys
     *
     * @return An enumeration of all defined keys
     */    
    public Enumeration getKeys()
    {
        return cache.keys();
    }
    
    /** 
     * Remove an entry from the cache
     *
     * @param key The unique key of the entry to remove
     */    
    public void removeElement(Object key)
    {
        cache.remove(key);       
    }
}

/**
 * $Log: GenericCache.java,v $
 * Revision 1.8  2003/03/12 13:20:09  joerg
 * New methods to support unit-tests
 *
 * Revision 1.7  2003/01/01 21:03:49  joerg
 * Copyright-Statement aktualisiert
 *
 * Revision 1.6  2002/12/10 21:53:38  joerg
 * Copyright-Statement korrigiert.
 *
 * Revision 1.5  2002/11/30 14:54:11  joerg
 * Javadoc ergaenzt
 *
 * Revision 1.4  2002/11/26 14:38:13  joerg
 * Fehlende synchronize-Statements nachgeruestet.
 *
 * Revision 1.3  2002/11/23 14:21:52  joerg
 * GPL-Statements eingefuegt
 *
 * Revision 1.2  2002/11/23 14:16:28  joerg
 * JavaDoc-Kommentare eingefuegt
 *
 * Revision 1.1  2002/11/01 21:36:47  joerg
 * Version mit funktionierenden 1st-level Cache
 *
 */
