/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.xmlconfig;

import de.iiit.util.LogUtil;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Configuration {
    private static final String vcid = "$Id: Configuration.java,v 1.15 2003/04/02 15:58:01 joerg Exp $";
    private String name;
    private Hashtable attributes = new Hashtable();
    private Vector subConfigs = new Vector();

    private Configuration() {
    }

    protected Configuration(String name) {
        this.name = name;
    }

    public static Configuration load(String filename) throws FileNotFoundException, IOException, SAXException {
        return new Reader().readConfigFile(filename);
    }

    public void save(String filename) throws IOException {
        StringBuffer buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        buffer.append(this.toXML());
        FileWriter fw = new FileWriter(filename);
        fw.write(buffer.toString());
        fw.close();
    }

    private String indentSpace(int indent) {
        String space = "";
        int i = 0;
        while (i < indent) {
            space = space + "  ";
            ++i;
        }
        return space;
    }

    private StringBuffer toXML(int indent) {
        StringBuffer buffer = new StringBuffer();
        String space = this.indentSpace(indent);
        boolean attributeEmptyFlag = this.attributes.isEmpty();
        boolean subConfigEmptyFlag = this.subConfigs.isEmpty();
        if (attributeEmptyFlag && subConfigEmptyFlag) {
            buffer.append(space + "<" + this.name + "/>\n\n");
        } else if (attributeEmptyFlag) {
            buffer.append(space + "<" + this.name + ">\n");
        } else {
            buffer.append(space + "<" + this.name + "\n");
            Enumeration keys = this.attributes.keys();
            while (keys.hasMoreElements()) {
                String k = (String)keys.nextElement();
                String v = this.getAttribute(k);
                buffer.append(space + "  " + k + "\t= \"" + v + "\"\n");
            }
            if (subConfigEmptyFlag) {
                buffer.append(space + "/>\n\n");
            } else {
                buffer.append(space + ">\n");
            }
        }
        if (!subConfigEmptyFlag) {
            Iterator i = this.subConfigs.iterator();
            while (i.hasNext()) {
                buffer.append(((Configuration)i.next()).toXML(indent + 1));
            }
            buffer.append(space + "</" + this.getName() + ">\n\n");
        }
        return buffer;
    }

    public StringBuffer toXML() {
        return this.toXML(0);
    }

    private void printLine(Logger logger, String msg) {
        if (logger != null) {
            logger.debug((Object)msg);
        } else {
            System.out.println(msg);
        }
    }

    private void printConfig(Logger logger, int indent) {
        String space = this.indentSpace(indent);
        this.printLine(logger, space + "Sub-Config: " + this.getName());
        Enumeration keys = this.getAttributeKeys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            String v = this.getAttribute(k);
            this.printLine(logger, space + "  " + k + " => " + v);
        }
        Vector v = this.getSubConfigurations();
        int iMax = v.size();
        int i = 0;
        while (i < iMax) {
            ((Configuration)v.get(i)).printConfig(logger, indent + 1);
            ++i;
        }
    }

    public void logConfig() {
        this.printConfig(Logger.getLogger(this.getClass()), 0);
    }

    public void printConfig() {
        this.printConfig(null, 0);
    }

    protected void setName(String name) {
        this.name = name;
    }

    public void addSubConfiguration(Configuration config) {
        this.subConfigs.add(config);
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key.toLowerCase(), value);
    }

    public String getName() {
        return this.name;
    }

    public Vector getSubConfigurations() {
        return this.subConfigs;
    }

    public Vector getSubConfigurations(String name) {
        Vector v = this.getSubConfigurations();
        Vector<Configuration> result = new Vector<Configuration>();
        name = name.toLowerCase();
        int iMax = v.size();
        int i = 0;
        while (i < iMax) {
            Configuration c = (Configuration)v.get(i);
            if (c.getName().equals(name)) {
                result.add(c);
            }
            ++i;
        }
        return result.size() > 0 ? result : null;
    }

    public Configuration getSubConfiguration(String name) {
        Configuration result = null;
        Vector v = this.getSubConfigurations(name);
        if (v != null) {
            result = (Configuration)v.get(0);
        }
        return result;
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String key) {
        return (String)this.attributes.get(key.toLowerCase());
    }

    public int getIntAttribute(String key) {
        String s = (String)this.attributes.get(key.toLowerCase());
        if (s != null) {
            return Integer.parseInt(s);
        }
        return 0;
    }

    public boolean getBooleanAttribute(String key) {
        String s = (String)this.attributes.get(key.toLowerCase());
        return s != null && (s.equalsIgnoreCase("TRUE") || s.equalsIgnoreCase("YES") || s.equalsIgnoreCase("1"));
    }

    public String getAttribute(String key, String defaultValue) {
        String v = (String)this.attributes.get(key.toLowerCase());
        if (v == null) {
            v = defaultValue;
        }
        return v;
    }

    public int getIntAttribute(String key, int defaultValue) {
        return Integer.parseInt(this.getAttribute(key, String.valueOf(defaultValue)));
    }

    public boolean getBooleanAttribute(String key, boolean defaultValue) {
        String s = (String)this.attributes.get(key.toLowerCase());
        if (s != null) {
            return s.equalsIgnoreCase("TRUE") || s.equalsIgnoreCase("YES") || s.equals("1");
        }
        return defaultValue;
    }

    public Enumeration getAttributeKeys() {
        return this.attributes.keys();
    }

    private static class Reader
    extends DefaultHandler {
        private static final String vcid = "$Id: Configuration.java,v 1.15 2003/04/02 15:58:01 joerg Exp $";
        private Configuration rootConfig = null;
        private Configuration currentConfig = null;
        private Stack configStack = new Stack();
        private Logger logger = Logger.getLogger(this.getClass());

        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            Configuration c = new Configuration(qName.toLowerCase());
            if (this.rootConfig == null) {
                this.rootConfig = c;
                this.configStack.push(c);
            } else {
                this.currentConfig.addSubConfiguration(c);
                this.configStack.push(this.currentConfig);
            }
            this.currentConfig = c;
            int iMax = attrs.getLength();
            int i = 0;
            while (i < iMax) {
                c.addAttribute(attrs.getQName(i).toLowerCase(), attrs.getValue(i));
                ++i;
            }
        }

        public void endElement(String uri, String localName, String qName) {
            this.currentConfig = (Configuration)this.configStack.pop();
        }

        public Configuration readConfigFile(String filename) throws FileNotFoundException, IOException, SAXException {
            boolean logFlag = LogUtil.loggerIsInitialized();
            String msg = "Start reading file <" + filename + ">";
            if (logFlag) {
                this.logger.debug((Object)msg);
            } else {
                System.out.println(msg);
            }
            this.rootConfig = null;
            this.currentConfig = null;
            SAXParser p = new SAXParser();
            p.setContentHandler((ContentHandler)this);
            p.parse(new InputSource(new FileReader(filename)));
            msg = "Finished reading file <" + filename + ">.";
            if (logFlag) {
                this.logger.debug((Object)msg);
            } else {
                System.out.println(msg);
            }
            return this.rootConfig;
        }
    }
}

