/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.xmlconfig;

import de.iiit.util.LogUtil;
import de.iiit.xmlconfig.Configuration;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigReader
extends DefaultHandler {
    private static final String vcid = "$Id: ConfigReader.java,v 1.12 2003/04/02 15:56:30 joerg Exp $";
    private Configuration rootConfig = null;
    private Configuration currentConfig = null;
    private Stack configStack = new Stack();
    private Logger logger = Logger.getLogger(this.getClass());

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Configuration c = new Configuration(qName.toLowerCase());
        if (this.rootConfig == null) {
            this.rootConfig = c;
            this.configStack.push(c);
        } else {
            this.currentConfig.addSubConfiguration(c);
            this.configStack.push(this.currentConfig);
        }
        this.currentConfig = c;
        int iMax = attrs.getLength();
        int i = 0;
        while (i < iMax) {
            c.addAttribute(attrs.getQName(i).toLowerCase(), attrs.getValue(i));
            ++i;
        }
    }

    public void endElement(String uri, String localName, String qName) {
        this.currentConfig = (Configuration)this.configStack.pop();
    }

    public Configuration readConfigFile(String filename) throws FileNotFoundException, IOException, SAXException {
        boolean logFlag = LogUtil.loggerIsInitialized();
        String msg = "Start reading file <" + filename + ">";
        if (logFlag) {
            this.logger.debug((Object)msg);
        } else {
            System.out.println(msg);
        }
        this.rootConfig = null;
        this.currentConfig = null;
        SAXParser p = new SAXParser();
        p.setContentHandler((ContentHandler)this);
        p.parse(new InputSource(new FileReader(filename)));
        msg = "Finished reading file <" + filename + ">.";
        if (logFlag) {
            this.logger.debug((Object)msg);
        } else {
            System.out.println(msg);
        }
        return this.rootConfig;
    }
}

