/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StringUtil {
    private static final String vcid = "$Id: StringUtil.java,v 1.9 2003/03/12 21:06:38 joerg Exp $";
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static MessageDigest md5 = null;

    private StringUtil() {
    }

    public static final String removeSpaces(String s) {
        return s.replaceAll(" ", "");
    }

    public static final String byteArrayToHexString(byte[] b) {
        char[] buffer = new char[b.length * 2];
        int k = 0;
        int i = 0;
        while (i < b.length) {
            int low = b[i] & 0xF;
            int high = (b[i] & 0xF0) >> 4;
            buffer[k++] = hexadecimal[high];
            buffer[k++] = hexadecimal[low];
            ++i;
        }
        return new String(buffer);
    }

    public static final byte[] hexStringToByteArray(String s) {
        int l = s.length() / 2;
        byte[] buffer = new byte[l];
        int j = 0;
        int i = 0;
        while (i < l) {
            int k = j + 2;
            String b = s.substring(j, k);
            buffer[i] = (byte)Integer.parseInt(b, 16);
            j = k;
            ++i;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5Sum(byte[] source) throws NoSuchAlgorithmException {
        byte[] md5Bytes;
        if (md5 == null) {
            md5 = MessageDigest.getInstance("MD5");
        }
        MessageDigest messageDigest = md5;
        synchronized (messageDigest) {
            md5Bytes = md5.digest(source);
        }
        return StringUtil.byteArrayToHexString(md5Bytes);
    }

    public static String md5Sum(String source) throws NoSuchAlgorithmException {
        return StringUtil.md5Sum(source.getBytes());
    }
}

