/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.util;

import de.iiit.xmlconfig.Configuration;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class LogUtil {
    private static final String vcid = "$Id: LogUtil.java,v 1.12 2003/04/02 09:25:53 joerg Exp $";
    private static String CONFIG_LOGLEVEL = "LogLevel";
    private static String CONFIG_LOGLAYOUT = "LogLayout";
    private static String CONFIG_LOGFILE = "LogFile";
    private static String CONFIG_MAXFILESIZE = "MaxFileSize";
    private static String CONFIG_MAXBACKUPFILES = "MaxBackupFiles";
    private static Level defaultLevel = Level.DEBUG;
    private static String defaultLayout = "%d [%t] %-5p %c{1} - %m%n";
    private static boolean initialized = false;
    private static Logger logger = Logger.getLogger((String)"LogUtil");

    public static final boolean loggerIsInitialized() {
        return initialized;
    }

    public static final void init(Level level) {
        if (!initialized) {
            Logger.getRootLogger().setLevel(level);
            PatternLayout layout = new PatternLayout(defaultLayout);
            ConsoleAppender appender = new ConsoleAppender((Layout)layout, "System.out");
            BasicConfigurator.configure((Appender)appender);
            initialized = true;
            logger.info((Object)("Logging system initialized, log level = <" + level.toString() + ">"));
        }
    }

    public static final void init(String level, Level defaultLevel) {
        LogUtil.init(Level.toLevel((String)level, (Level)defaultLevel));
    }

    public static final void init(Level level, String filename, int maxFileSize, int maxBackupFiles) {
        ConsoleAppender appender;
        block4: {
            PatternLayout layout = new PatternLayout(defaultLayout);
            appender = null;
            if (filename == null || filename.equals("")) {
                appender = new ConsoleAppender((Layout)layout, "System.out");
            } else {
                try {
                    appender = new RollingFileAppender((Layout)layout, filename);
                    ((RollingFileAppender)appender).setMaxBackupIndex(maxBackupFiles);
                    ((RollingFileAppender)appender).setMaximumFileSize((long)maxFileSize);
                }
                catch (IOException ioe) {
                    appender = new ConsoleAppender((Layout)layout, "System.out");
                    if (!initialized) break block4;
                    logger.error((Object)("Can't configure log file <" + filename + ">"));
                }
            }
        }
        BasicConfigurator.resetConfiguration();
        Logger.getRootLogger().setLevel(level);
        BasicConfigurator.configure((Appender)appender);
        initialized = true;
        logger.info((Object)("Logging system initialized, log level = <" + level.toString() + ">"));
    }

    public static final void init(String level, String filename, int maxFileSize, int maxBackupFiles) {
        LogUtil.init(Level.toLevel((String)level, (Level)defaultLevel), filename, maxFileSize, maxBackupFiles);
    }

    public static final void init(Level level, String filename) {
        LogUtil.init(level, filename, 1000000, 5);
    }

    public static final void init(String level, String filename) {
        LogUtil.init(Level.toLevel((String)level, (Level)defaultLevel), filename);
    }

    public static final void init(Configuration config, Level defaultLevel) {
        block4: {
            if (initialized) break block4;
            String logFile = config.getAttribute(CONFIG_LOGFILE);
            String logLevel = config.getAttribute(CONFIG_LOGLEVEL);
            String logLayout = config.getAttribute(CONFIG_LOGLAYOUT, defaultLayout);
            int maxFileSize = config.getIntAttribute(CONFIG_MAXFILESIZE, 1000000);
            int maxBackupFiles = config.getIntAttribute(CONFIG_MAXBACKUPFILES, 5);
            if (logFile == null || logFile.equals("")) {
                LogUtil.init(logLevel, defaultLevel);
            } else {
                try {
                    Level level = Level.toLevel((String)logLevel, (Level)defaultLevel);
                    Logger.getRootLogger().setLevel(level);
                    PatternLayout layout = new PatternLayout(logLayout);
                    RollingFileAppender appender = new RollingFileAppender((Layout)layout, logFile);
                    appender.setMaxBackupIndex(maxBackupFiles);
                    appender.setMaximumFileSize((long)maxFileSize);
                    BasicConfigurator.configure((Appender)appender);
                    initialized = true;
                    logger.info((Object)("Logging system initialized, log level = <" + level.toString() + ">"));
                    System.out.println("Logging to file <" + logFile + ">");
                }
                catch (IOException ie) {
                    LogUtil.init(logLevel, defaultLevel);
                    logger.error((Object)("Caught IOException while configuring log file <" + logFile + ">"), (Throwable)ie);
                }
            }
        }
    }

    public static final void init(Configuration config) {
        LogUtil.init(config, defaultLevel);
    }

    public static final void init() {
        LogUtil.init(Level.DEBUG);
    }
}

