/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.util;

import de.iiit.util.LogUtil;
import java.io.File;
import org.apache.log4j.Logger;

public class FileSearch {
    private static final String vcid = "$Id: FileSearch.java,v 1.7 2003/01/01 21:03:49 joerg Exp $";
    private static final String[] DEFAULT_PATH = new String[]{".", "etc", "/usr/local/etc", "/etc"};
    private static String[] searchPath = DEFAULT_PATH;
    private static String searchPathAsString = null;
    private static Logger logger = Logger.getLogger((String)"FileSearch");

    protected FileSearch() {
    }

    public static void setSearchPath(String[] path) {
        searchPath = path;
        searchPathAsString = null;
    }

    public static String[] getSearchPath() {
        return searchPath;
    }

    public static String getSearchPathAsString() {
        if (searchPathAsString == null) {
            searchPathAsString = "";
            int iMax = searchPath.length;
            int i = 0;
            while (i < iMax) {
                if (i > 0) {
                    searchPathAsString = searchPathAsString + File.pathSeparator;
                }
                searchPathAsString = searchPathAsString + searchPath[i];
                ++i;
            }
        }
        return searchPathAsString;
    }

    public static String search(String filename) {
        String result = null;
        String msg = "Searching for <" + filename + "> in <" + FileSearch.getSearchPathAsString() + ">";
        boolean logFlag = LogUtil.loggerIsInitialized();
        if (logFlag) {
            logger.debug((Object)msg);
        } else {
            System.out.println(msg);
        }
        int iMax = searchPath.length;
        int i = 0;
        while (i < iMax && result == null) {
            File file = new File(searchPath[i], filename);
            if (file.canRead()) {
                msg = "File <" + filename + "> found in <" + searchPath[i] + ">";
                if (logFlag) {
                    logger.debug((Object)msg);
                } else {
                    System.out.println(msg);
                }
                result = file.getPath();
            }
            ++i;
        }
        return result;
    }
}

