/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.ldap;

import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapContext;
import org.apache.log4j.Logger;

public class LdapGenericObject {
    private static final String vcid = "$Id: LdapGenericObject.java,v 1.9 2003/01/01 21:03:49 joerg Exp $";
    private Logger logger = Logger.getLogger(this.getClass());
    private String name = null;
    private String base = null;
    private LdapContext context = null;
    private Hashtable attributes = new Hashtable();

    public LdapGenericObject() {
    }

    public LdapGenericObject(LdapContext context, String name, String base) {
        this.name = name;
        this.base = base;
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public String getBase() {
        return this.base;
    }

    public String getAbsoluteName() {
        return this.name + "," + this.base;
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public Vector getAttribute(String key) {
        return (Vector)this.attributes.get(key);
    }

    public void setAttribute(String key, Vector values) {
        this.attributes.put(key, values);
    }

    public void setAttribute(String key, NamingEnumeration values) throws NamingException {
        Vector v = new Vector();
        while (values.hasMore()) {
            v.add(values.next());
        }
        this.setAttribute(key, v);
    }

    public void setAttribute(Attribute attribute) throws NamingException {
        this.setAttribute(attribute.getID(), attribute.getAll());
    }

    public void setAttributes(Attributes attributes) throws NamingException {
        NamingEnumeration<? extends Attribute> ne = attributes.getAll();
        while (ne.hasMore()) {
            this.setAttribute(ne.next());
        }
    }
}

