/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.ldap;

import de.iiit.xmlconfig.Configuration;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.log4j.Logger;

public class LdapConnectionManager {
    private static final String vcid = "$Id: LdapConnectionManager.java,v 1.12 2003/01/01 21:03:49 joerg Exp $";
    private Logger logger = Logger.getLogger(this.getClass());
    private Vector initialContexts = new Vector();
    private int nextContext = 0;
    private Vector ldapConfigs = new Vector();
    private Vector lostConfigs = new Vector();
    private Hashtable masterConfig = null;
    private InitialLdapContext masterContext = null;
    private ContextRefresher refresher = null;

    private LdapConnectionManager() {
    }

    public LdapConnectionManager(Vector serverConfig, int masterServerNumber, int refreshIntervall) {
        int iMax = serverConfig.size();
        int i = 0;
        while (i < iMax) {
            Configuration envCfg = (Configuration)serverConfig.get(i);
            Hashtable<String, String> env = new Hashtable<String, String>();
            String url = envCfg.getAttribute("java.naming.provider.url");
            Enumeration keys = envCfg.getAttributeKeys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.indexOf(".") == 0) continue;
                env.put(key.toLowerCase(), envCfg.getAttribute(key));
                this.logger.info((Object)("LDAP config: <" + key.toLowerCase() + "> - <" + envCfg.getAttribute(key) + ">"));
            }
            try {
                InitialLdapContext context = new InitialLdapContext(env, null);
                if (i == masterServerNumber) {
                    this.masterConfig = env;
                    this.masterContext = context;
                    this.logger.info((Object)("LDAP server " + url + " configured as master server"));
                } else {
                    this.initialContexts.add(context);
                    this.ldapConfigs.add(env);
                    this.logger.info((Object)("LDAP server " + url + " configured"));
                }
            }
            catch (NamingException ne) {
                String msg = "Failed to initialize ldap context no. " + i + ": " + ne.getExplanation();
                Throwable t = ne.getRootCause();
                if (t != null) {
                    msg = msg + " - " + t.getMessage();
                }
                this.logger.error((Object)msg);
                if (i == masterServerNumber) {
                    this.masterConfig = env;
                }
                this.lostConfigs.add(env);
            }
            ++i;
        }
        if (this.masterContext == null) {
            this.logger.warn((Object)"No master context configured, switching to read-only mode");
        }
        this.refresher = new ContextRefresher(refreshIntervall);
        this.refresher.start();
    }

    public void shutdown() {
        this.refresher.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapContext getContext() {
        LdapContext result = null;
        while (result == null && this.initialContexts.size() > 0) {
            try {
                if (this.nextContext >= this.initialContexts.size()) {
                    this.nextContext = 0;
                }
                InitialLdapContext iContext = (InitialLdapContext)this.initialContexts.get(this.nextContext);
                LdapContext ctx = iContext.newInstance(null);
                ctx.reconnect(null);
                result = ctx;
                ++this.nextContext;
            }
            catch (NamingException ne) {
                this.logger.error((Object)ne.getMessage(), (Throwable)ne);
                Hashtable env = (Hashtable)this.ldapConfigs.get(this.nextContext);
                String url = (String)env.get("java.naming.provider.url");
                this.logger.warn((Object)("LDAP server " + url + " lost."));
                Vector vector = this.lostConfigs;
                synchronized (vector) {
                    this.ldapConfigs.remove(this.nextContext);
                    this.initialContexts.remove(this.nextContext);
                    this.lostConfigs.add(env);
                }
            }
        }
        if (result == null) {
            this.logger.error((Object)"No LDAP server available");
        }
        return result;
    }

    private class ContextRefresher
    extends Thread {
        private long sleepTime;
        private boolean running = true;

        ContextRefresher(long sleepTime) {
            this.sleepTime = sleepTime;
            this.setPriority(1);
        }

        protected void shutdown() {
            this.running = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                int i = 0;
                while (i < LdapConnectionManager.this.lostConfigs.size()) {
                    try {
                        Hashtable env = (Hashtable)LdapConnectionManager.this.lostConfigs.get(i);
                        InitialLdapContext context = new InitialLdapContext(env, null);
                        context.reconnect(null);
                        Vector vector = LdapConnectionManager.this.lostConfigs;
                        synchronized (vector) {
                            LdapConnectionManager.this.initialContexts.add(context);
                            LdapConnectionManager.this.ldapConfigs.add(env);
                            LdapConnectionManager.this.lostConfigs.remove(i);
                        }
                        String url = (String)env.get("java.naming.provider.url");
                        LdapConnectionManager.this.logger.info((Object)("LDAP server " + url + " up again"));
                    }
                    catch (NamingException ne) {
                        ++i;
                    }
                }
                if (LdapConnectionManager.this.masterContext == null && LdapConnectionManager.this.masterConfig != null) {
                    try {
                        InitialLdapContext context = new InitialLdapContext(LdapConnectionManager.this.masterConfig, null);
                        LdapConnectionManager.this.masterContext = context;
                        String url = (String)LdapConnectionManager.this.masterConfig.get("java.naming.provider.url");
                        LdapConnectionManager.this.logger.info((Object)("LDAP master server " + url + " up again"));
                    }
                    catch (NamingException ne) {
                        // empty catch block
                    }
                }
                if (!this.running) continue;
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

