/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.jdbc;

import de.iiit.xmlconfig.Configuration;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Vector;
import org.apache.log4j.Logger;

public class JdbcUtil {
    private static final String vcid = "$Id: JdbcUtil.java,v 1.7 2003/01/01 21:03:49 joerg Exp $";
    public static final String JDBC_DRIVER = "ClassName";
    private static Logger logger = Logger.getLogger((String)"JdbcUtil");

    private JdbcUtil() {
    }

    public static void registerJdbcDriver(Vector cfgVector) throws Exception {
        String className = null;
        try {
            int iMax = cfgVector.size();
            int i = 0;
            while (i < iMax) {
                Configuration cfg = (Configuration)cfgVector.get(i);
                className = cfg.getAttribute(JDBC_DRIVER);
                Class<?> driverClass = Class.forName(className);
                Driver driver = (Driver)driverClass.newInstance();
                DriverManager.registerDriver(driver);
                logger.info((Object)("JDBC driver <" + className + "> successful registered"));
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            logger.fatal((Object)("Class <" + className + "> not found"), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.fatal((Object)("Can't register driver of class <" + className + ">"));
            throw e;
        }
    }
}

