/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.jdbc;

import de.iiit.jdbc.JdbcConnection;
import de.iiit.jdbc.JdbcException;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcStatement {
    private static final String vcid = "$Id: JdbcStatement.java,v 1.6 2003/01/01 21:03:49 joerg Exp $";
    private JdbcConnection connection = null;
    private Statement statement = null;

    private JdbcStatement() {
    }

    protected JdbcStatement(JdbcConnection connection, Statement statement) {
        this.connection = connection.lock();
        this.statement = statement;
    }

    public boolean execute(String sql) throws JdbcException {
        try {
            return this.statement.execute(sql);
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public void close() throws JdbcException {
        try {
            this.statement.close();
            this.connection.release();
            this.connection = null;
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.connection != null) {
            this.connection.release();
        }
    }
}

