/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.jdbc;

import de.iiit.jdbc.JdbcConnection;
import de.iiit.jdbc.JdbcException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JdbcResultSet {
    private static final String vcid = "$Id: JdbcResultSet.java,v 1.6 2003/01/01 21:03:49 joerg Exp $";
    private JdbcConnection connection = null;
    private ResultSet resultSet = null;

    private JdbcResultSet() {
    }

    protected JdbcResultSet(JdbcConnection connection, ResultSet resultSet) {
        this.connection = connection.lock();
        this.resultSet = resultSet;
    }

    public void close() throws JdbcException {
        try {
            this.resultSet.close();
            this.connection.release();
            this.connection = null;
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public boolean next() throws JdbcException {
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public boolean first() throws JdbcException {
        try {
            return this.resultSet.first();
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public int getInt(int columnIndex) throws JdbcException {
        try {
            return this.resultSet.getInt(columnIndex);
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public long getLong(int columnIndex) throws JdbcException {
        try {
            return this.resultSet.getLong(columnIndex);
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public String getString(int columnIndex) throws JdbcException {
        try {
            return this.resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    protected void finalize() throws Throwable {
        this.connection.release();
    }
}

