/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.jdbc;

import de.iiit.jdbc.JdbcConnection;
import de.iiit.jdbc.JdbcException;
import de.iiit.jdbc.JdbcResultSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JdbcPreparedStatement {
    private static final String vcid = "$Id: JdbcPreparedStatement.java,v 1.6 2003/01/01 21:03:49 joerg Exp $";
    private JdbcConnection connection = null;
    private PreparedStatement statement = null;

    private JdbcPreparedStatement() {
    }

    protected JdbcPreparedStatement(JdbcConnection connection, PreparedStatement statement) {
        this.connection = connection.lock();
        this.statement = statement;
    }

    public JdbcResultSet executeQuery() throws JdbcException {
        try {
            return new JdbcResultSet(this.connection, this.statement.executeQuery());
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public int executeUpdate() throws JdbcException {
        try {
            return this.statement.executeUpdate();
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public void clearBatch() throws JdbcException {
        try {
            this.statement.clearBatch();
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public void clearWarnings() throws JdbcException {
        try {
            this.statement.clearWarnings();
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public void close() throws JdbcException {
        try {
            this.statement.close();
            this.connection.release();
            this.connection = null;
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public void setString(int parameterIndex, String x) throws JdbcException {
        try {
            this.statement.setString(parameterIndex, x);
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public void setLong(int parameterIndex, long x) throws JdbcException {
        try {
            this.statement.setLong(parameterIndex, x);
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    protected void finalize() throws Throwable {
        this.connection.release();
    }
}

