/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.jdbc;

import de.iiit.jdbc.JdbcConnection;
import de.iiit.jdbc.JdbcException;
import de.iiit.jdbc.JdbcResultSet;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class JdbcDatabaseMetaData {
    private static final String vcid = "$Id: JdbcDatabaseMetaData.java,v 1.6 2003/01/01 21:03:49 joerg Exp $";
    private JdbcConnection connection = null;
    private DatabaseMetaData metaData = null;

    private JdbcDatabaseMetaData() {
    }

    protected JdbcDatabaseMetaData(JdbcConnection connection, DatabaseMetaData metaData) {
        this.connection = connection.lock();
        this.metaData = metaData;
    }

    public JdbcResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws JdbcException {
        try {
            return new JdbcResultSet(this.connection, this.metaData.getTables(catalog, schemaPattern, tableNamePattern, types));
        }
        catch (SQLException e) {
            this.connection.destroyConnection();
            throw new JdbcException(e);
        }
    }

    public void close() {
        this.connection.release();
        this.connection = null;
    }

    protected void finalize() throws Throwable {
        this.connection.release();
    }
}

