/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.jdbc;

import de.iiit.jdbc.JdbcConnection;
import de.iiit.jdbc.JdbcDatabaseMetaData;
import de.iiit.jdbc.JdbcException;
import de.iiit.jdbc.JdbcPreparedStatement;
import de.iiit.jdbc.JdbcStatement;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class JdbcConnectionPool {
    private static final String vcid = "$Id: JdbcConnectionPool.java,v 1.9 2003/04/02 09:25:08 joerg Exp $";
    private String url = null;
    private String user = null;
    private String password = null;
    private Vector freeConnections = new Vector();
    private Vector busyConnections = new Vector();
    private Logger logger = Logger.getLogger(this.getClass());

    private JdbcConnectionPool() {
    }

    public JdbcConnectionPool(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public JdbcConnectionPool(String url, String user, String password, int connections) {
        this(url, user, password);
        this.logger.info((Object)("Creating " + connections + " new connections to DB <" + url + ">."));
        if (connections > 0) {
            try {
                int i = 0;
                while (i < connections) {
                    this.freeConnections.add(new JdbcConnection(this, DriverManager.getConnection(url, user, password)));
                    ++i;
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"Caught SQLException while creating connections", (Throwable)e);
            }
            this.logger.info((Object)(this.freeConnections.size() + " new connection to DB <" + url + "> created."));
        }
    }

    public JdbcStatement createStatement() throws JdbcException {
        return this.getLockedConnection().createStatement();
    }

    public JdbcPreparedStatement prepareStatement(String sql) throws JdbcException {
        return this.getLockedConnection().prepareStatement(sql);
    }

    public JdbcDatabaseMetaData getMetaData() throws JdbcException {
        return this.getLockedConnection().getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcConnection getLockedConnection() throws JdbcException {
        JdbcConnection result = null;
        Vector vector = this.busyConnections;
        synchronized (vector) {
            if (this.freeConnections.isEmpty()) {
                try {
                    result = new JdbcConnection(this, DriverManager.getConnection(this.url, this.user, this.password));
                    this.logger.info((Object)("New connection to DB <" + this.url + "> created, having " + (this.busyConnections.size() + 1)));
                }
                catch (SQLException e) {
                    throw new JdbcException(e);
                }
            } else {
                result = (JdbcConnection)this.freeConnections.firstElement();
                this.freeConnections.remove(result);
            }
            this.busyConnections.add(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseConnection(JdbcConnection connection) {
        Vector vector = this.busyConnections;
        synchronized (vector) {
            if (this.busyConnections.contains(connection)) {
                this.busyConnections.remove(connection);
                this.freeConnections.add(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyConnection(JdbcConnection connection) {
        Vector vector = this.busyConnections;
        synchronized (vector) {
            if (this.busyConnections.contains(connection)) {
                this.busyConnections.remove(connection);
            }
        }
    }
}

