/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.jdbc;

import de.iiit.jdbc.JdbcConnectionPool;
import de.iiit.jdbc.JdbcDatabaseMetaData;
import de.iiit.jdbc.JdbcException;
import de.iiit.jdbc.JdbcPreparedStatement;
import de.iiit.jdbc.JdbcStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class JdbcConnection {
    private static final String vcid = "$Id: JdbcConnection.java,v 1.6 2003/01/01 21:03:49 joerg Exp $";
    private JdbcConnectionPool owner;
    private Connection connection;
    private int refCounter = 0;

    private JdbcConnection() {
    }

    protected JdbcConnection(JdbcConnectionPool owner, Connection connection) {
        this.owner = owner;
        this.connection = connection;
    }

    protected JdbcConnection lock() {
        ++this.refCounter;
        return this;
    }

    protected void release() {
        if (--this.refCounter == 0) {
            this.owner.releaseConnection(this);
        }
    }

    protected JdbcPreparedStatement prepareStatement(String sql) throws JdbcException {
        try {
            return new JdbcPreparedStatement(this, this.connection.prepareStatement(sql));
        }
        catch (SQLException e) {
            this.owner.destroyConnection(this);
            throw new JdbcException(e);
        }
    }

    protected JdbcStatement createStatement() throws JdbcException {
        try {
            return new JdbcStatement(this, this.connection.createStatement());
        }
        catch (SQLException e) {
            this.owner.destroyConnection(this);
            throw new JdbcException(e);
        }
    }

    protected JdbcDatabaseMetaData getMetaData() throws JdbcException {
        try {
            return new JdbcDatabaseMetaData(this, this.connection.getMetaData());
        }
        catch (SQLException e) {
            this.owner.destroyConnection(this);
            throw new JdbcException(e);
        }
    }

    protected void destroyConnection() {
        this.owner.destroyConnection(this);
    }

    protected void finalize() throws Throwable {
        try {
            this.connection.close();
        }
        catch (SQLException e) {}
    }
}

