/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.cache;

import de.iiit.cache.CacheFaultException;
import de.iiit.cache.GenericCache;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class GenericTimeoutCache
extends GenericCache {
    private static final String vcid = "$Id: GenericTimeoutCache.java,v 1.12 2003/04/14 20:38:02 joerg Exp $";
    private long timeout = -1L;
    private long sleeptime = 1000L;
    private CacheCleaner cleaner;
    private Logger logger = Logger.getLogger(this.getClass());

    public GenericTimeoutCache() {
        this(-1L, 1000L);
    }

    public GenericTimeoutCache(long timeout) {
        this(timeout, 1000L);
    }

    public GenericTimeoutCache(long timeout, long sleeptime) {
        this.timeout = timeout;
        if (timeout >= 0L) {
            this.cleaner = new CacheCleaner(sleeptime);
            this.cleaner.start();
        }
    }

    public void shutdown() {
        this.cleaner.shutdown();
    }

    public void addElement(Object key, Object value) {
        GenericTimeoutCacheElement ce = new GenericTimeoutCacheElement(this.timeout, value);
        super.addElement(key, ce);
    }

    public Object getElement(Object key) throws CacheFaultException {
        GenericTimeoutCacheElement ce = (GenericTimeoutCacheElement)super.getElement(key);
        ce.setTimeout(this.timeout);
        return ce.getValue();
    }

    protected long getElementTimeout(Object key) {
        try {
            GenericTimeoutCacheElement ce = (GenericTimeoutCacheElement)super.getElement(key);
            return ce.getTimeout();
        }
        catch (CacheFaultException e) {
            return -1L;
        }
    }

    private class GenericTimeoutCacheElement {
        private long timeout = -1L;
        private Object value;

        private GenericTimeoutCacheElement() {
        }

        protected GenericTimeoutCacheElement(long timeout) {
            if (timeout >= 0L) {
                this.timeout = System.currentTimeMillis() + timeout;
            }
        }

        protected GenericTimeoutCacheElement(long timeout, Object value) {
            if (timeout >= 0L) {
                this.timeout = System.currentTimeMillis() + timeout;
            }
            this.value = value;
        }

        protected void setTimeout(long timeout) {
            this.timeout = timeout >= 0L ? System.currentTimeMillis() + timeout : -1L;
        }

        protected long getTimeout() {
            return this.timeout;
        }

        protected Object getValue() {
            return this.value;
        }
    }

    private class CacheCleaner
    extends Thread {
        private long sleepTime;
        private boolean running = true;

        CacheCleaner(long sleepTime) {
            this.setName("CacheCleaner");
            this.sleepTime = sleepTime;
            this.setPriority(1);
        }

        protected void shutdown() {
            this.running = false;
            this.interrupt();
        }

        public void run() {
            while (this.running) {
                try {
                    Enumeration keys = GenericTimeoutCache.this.getKeys();
                    while (keys.hasMoreElements()) {
                        Object k = keys.nextElement();
                        long t = GenericTimeoutCache.this.getElementTimeout(k);
                        if (t > 0L && t < System.currentTimeMillis()) {
                            GenericTimeoutCache.this.logger.info((Object)("Timeout reached for key <" + k.toString() + ">"));
                            GenericTimeoutCache.this.removeElement(k);
                        }
                        if (!this.running) continue;
                        Thread.sleep(this.sleepTime);
                    }
                    if (!this.running) continue;
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.running = false;
        }
    }
}

