/*
 * Decompiled with CFR 0.152.
 */
package de.iiit.cache;

import de.iiit.cache.CacheFaultException;
import de.iiit.cache.GenericCache;

public class GenericInvalidationCache
extends GenericCache {
    private static final String vcid = "$Id: GenericInvalidationCache.java,v 1.7 2003/01/01 21:03:49 joerg Exp $";
    private long invalidationTimeout = -1L;

    public GenericInvalidationCache() {
    }

    public GenericInvalidationCache(long invalidationTimeout) {
        this.invalidationTimeout = invalidationTimeout;
    }

    public void addElement(Object key, Object value) {
        CacheElement ce = new CacheElement(this.invalidationTimeout, value);
        super.addElement(key, ce);
    }

    public Object getElement(Object key) throws CacheFaultException {
        CacheElement ce = (CacheElement)super.getElement(key);
        long t = ce.getInvalidationTime();
        if (t > 0L && t < System.currentTimeMillis()) {
            this.removeElement(key);
            throw new CacheFaultException();
        }
        return ce.getValue();
    }

    private class CacheElement {
        private long invalidationTime = -1L;
        private Object value;

        private CacheElement() {
        }

        protected CacheElement(long invalidationTimeout) {
            if (invalidationTimeout >= 0L) {
                this.invalidationTime = System.currentTimeMillis() + invalidationTimeout;
            }
        }

        protected CacheElement(long invalidationTimeout, Object value) {
            if (invalidationTimeout >= 0L) {
                this.invalidationTime = System.currentTimeMillis() + invalidationTimeout;
            }
            this.value = value;
        }

        protected long getInvalidationTime() {
            return this.invalidationTime;
        }

        protected Object getValue() {
            return this.value;
        }
    }
}

